<?php

function sclon2num($int, $array) {
  $cases = array (2, 0, 1, 1, 1, 2);
  
  if ($int == 0) {
    return '<span class="on">' . __('Бесплатно') . '</span>';
  }
  return $int . ' ' . $array[ ($int % 100 > 4 && $int % 100 < 20) ? 2 : $cases[min($int % 10, 5)] ];
}

$config = array(
  'module_page' => __('Магазин'),
  'module_name' => __('Магазин действий'),
  'module_dir'  => __DIR__,
  'icons_patch' => 'plugins/treats/icons',
  'goods_patch' => 'plugins/treats/goods',
  'style_patch' => 'plugins/treats/style',
  'icon_default' => 'default.png',
  'table_coins' => 'balls',
  'id_send_user' => '6',
  'coins_name' => array('балл', 'балла', 'баллов'),
  'return' => array(
      'guest' => '/guest/',
      'wall' => '/info.php?id=' . $object,
      'info' => '/info.php?id=' . $anketa['id'],
    ),
  'return_name' => array(
      'info' => $anketa['nick'],
      'guest' => 'Гостевая ',
      'wall' => 'Стена ' . ($from == 'wall' ? user::nick($object, 0) : 'пользователя'),
    ),
  'title_user' => array(
      'info' => 'Действия с ' . $anketa['nick'],
      'guest' => 'Угощения ' . $anketa['nick'] . ' в гостевой',
      'wall' => 'Угощения ' . $anketa['nick'] . ' на стене',
    ),
  'treats_type' => array(
      'compliment' => __('Комплименты'),
      'treats' => __('Угощения'),
      'action' => __('Действия'),
      ),
  'treats_notification' => array(
      'compliment' => '{login_user} cделал{i:а|} Вам комплимент: {icon} {name}',
      'treats' => '{login_user} угостил{i:а|} Вас: {icon} {name}',
      'action' => '{login_user} cделал{i:а|} над Вами действие: {icon} {name}',
      ),
);

// Уровень доступа
if (user_access('user_delete')) {
  $level = 1;
} else {
  $level = 0;
}

/**
* Лесенка возврата
*/
function preparePage($array) {
  $exp = preg_split('/\_/', str_replace('/', '_', $array), -1, PREG_SPLIT_NO_EMPTY);
  unset($exp[0]);
  
  $query = '';
  foreach($exp AS $key => $value) {
    $query .= ' OR `id` = ' . $value;
  }
  
  return $query;
}

function returnPage($id, $dir) {
  global $config, $func;
  
  $query = preparePage($dir);
  
  $c = mysql_query("SELECT `id`, `name` FROM `treats_category` WHERE `id` = '$id' $query");
  
  if ($id != 0) {
    $catalog = '<a href="?func=category&amp;id=0"><img src="/' . $config['icons_patch'] . '/arrow-180.png" /> ' . $config['module_page'] . '</a>';
  } else {
    $catalog = '<img src="/' . $config['icons_patch'] . '/church.png" /> ' . $config['module_name'];
  }
  
  while ($cat = mysql_fetch_assoc($c)) {
    if ($id == $cat['id'] && $func == 'category') {
      $catalog .= ' / ' . text($cat['name']) . '';
    } else {
      $catalog .= ' / <a href="?func=category&amp;id=' . $cat['id'] . '">' . text($cat['name']) . '</a>';
    }
  }
  return $catalog;
}

// Замена текста по признаку пола
function prepareSex($s) {
  global $anketa, $user;
  
  $i = array('s' => $anketa['pol'], 'i' => $user['pol']);
  $exp = explode('|', $s[2]);
  
  return $exp[$i[$s[1]]];
}

// Замена текста
function prepareMsg() {
  global $goods, $user, $anketa, $config;
  
  $goods['msg'] = preg_replace_callback('/\{(i|s)\:(.*?)\}/i', 'prepareSex', $goods['msg']);

  $search = array( 
  '{id_user}', 
  '{id_send}', 
  '{login_user}', 
  '{login_send}', 
  '{id}', 
  '{name}', 
  '{icon}', 
  '{id_category}', 
  '{coins}', 
  '{а}');

  $replace = array(
  $user['id'], 
  $anketa['id'], 
  $user['nick'], 
  $anketa['nick'], 
  $goods['id'], 
  $goods['name'], 
  '[img]/'. $config['goods_patch'] .'/'. $goods['icon'] .'.png[/img]', 
  $goods['id_category'], 
  $goods['coins'], 
  ($user['pol'] == 1 ? '' : 'а') );

   return str_replace($search, $replace, $goods['msg']);
}

// Шапка модуля
function moduleHeader($text) {
  global $set, $time, $user, $err, $db;
  
  $set['title'] = $text;
  
  require H.'sys/inc/thead.php';
  title();
  aut();
  err();
}

// Массив с иконками
$opendiricon = opendir(H . $config['icons_patch']);
while ($file_icons = readdir($opendiricon)) {
    if (!preg_match('/^[0-9A-Z\_\-]+\.(?:jp(?:e?g|e|2)|gif|png|tiff?|bmp|ico)$/i', $file_icons)) {
      continue;
    }
    
    $icons[] = $file_icons;
}
closedir($opendiricon);